# 🏹 Web Panahan

Sistem manajemen turnamen panahan modern untuk pendaftaran, scoring, dan analitik.

## 🚀 Quick Start (Docker)

1. **Clone & Enter**
   ```bash
   git clone https://github.com/HikaruTofu/web-panahan.git
   cd web-panahan
   ```

2. **Jalankan**
   ```bash
   docker-compose up -d
   ```
   Akses: [http://localhost:8080](http://localhost:8080)

## 🔐 Security Status

Sistem telah di-harden sesuai standar **OWASP Top 10:2025**:
- **Rate Limiting**: Proteksi brute-force & abuse di semua API & form.
- **Input Sanitization**: Global cleaning untuk mencegah XSS & SQLi.
- **Access Control**: Role-based access (Admin/User) yang ketat.
- **CSRF Protection**: Token validasi pada semua state-changing actions.

## 🛠️ Tech Stack

- **Backend**: PHP 8.x + MySQL 8.0
- **Frontend**: Tailwind CSS + Chart.js
- **DevOps**: Docker & Docker Compose

## 📋 SQL Migration (PENTING)

Jika melakukan update dari versi lama ke versi terbaru, Anda **WAJIB** menjalankan perintah SQL di bawah ini agar sistem mengenali role baru (`petugas`).

### Cara Update via phpMyAdmin:
1. Masuk ke **phpMyAdmin** server Anda.
2. Pilih database yang digunakan (`panahan_turnament_new`).
3. Klik tab **"SQL"** di bagian atas.
4. Copy-paste perintah di bawah ini (pilih yang sesuai kebutuhan Anda):

**A. Update Role & Performance (WAJIB):**
```sql
-- 1. Tambah Index Performa (Sangat disarankan untuk database besar)
ALTER TABLE score ADD INDEX idx_kb (score_board_id), ADD INDEX idx_ps (peserta_id), ADD INDEX idx_kg (kegiatan_id);
ALTER TABLE peserta ADD INDEX idx_kg (kegiatan_id);
ALTER TABLE score_boards ADD INDEX idx_kg (kegiatan_id);

-- 3. Tambah kolom audit (jika upgrade dari versi < 2.0)
ALTER TABLE peserta 
ADD COLUMN IF NOT EXISTS created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
ADD COLUMN IF NOT EXISTS updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP;
```

5. Klik tombol **"Go"** atau **"Kirim"**.
6. **Selesai!** Aplikasi sekarang lebih cepat dan mendukung role baru.

## 👤 Login Default

*Silakan cek database/setup awal untuk detail kredensial admin.*

## 💾 Live Deployment & Backup

Jika Anda ingin men-*deploy* ke server live atau memindahkan data:
1.  Gunakan file `latest_database_backup.sql` yang tersedia di root project.
2.  Import file tersebut ke database target (MySQL 8.0+ disarankan).
3.  Pastikan file `config/panggil.php` sudah dikonfigurasi dengan `sname`, `uname`, `pwd`, dan `database` yang benar sesuai server live Anda.

---
Made with ❤️ for Indonesian Archery Community 🇮🇩
